/*
 * Decompiled with CFR 0.152.
 */
package terrablender.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_5455;
import net.minecraft.class_5458;

public class RegistryUtils {
    private static Optional<class_5455> registryAccess = Optional.empty();
    private static List<Consumer<class_5455>> registryAccessCaptureOneShotListeners = Lists.newArrayList();

    public static void captureCurrentRegistryAccess(class_5455 access) {
        registryAccess = Optional.of(access);
        registryAccessCaptureOneShotListeners.forEach(listener -> listener.accept(access));
        registryAccessCaptureOneShotListeners.clear();
    }

    public static void clearCurrentRegistryAccess() {
        registryAccess = Optional.empty();
    }

    public static void doWithRegistryAccess(Consumer<class_5455> listener) {
        if (registryAccess.isPresent()) {
            listener.accept(registryAccess.get());
        } else {
            registryAccessCaptureOneShotListeners.add(listener);
        }
    }

    public static class_5455 getCurrentRegistryAccess() {
        return registryAccess.orElse(class_5458.field_36476);
    }
}

